<?php include('head.php') ?>
<body class="main-body app sidebar-mini ltr light-theme open">

<?php include('header.php') ?>

<?php include('sidebar.php') ?>
<div class="jumps-prevent" style="padding-top: 20px;"></div>


<div class="main-content app-content">

<div class="main-container container-fluid">

<div class="main-content-body">
<div class="row row-sm">

<?php if($_REQUEST['inc']=='new'){?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
  $('#userId').on('input', function(){
    var userid = $(this).val().trim();

    if(userid.length === 0) {
      $('#userNameResult').html('');
      return;
    }

    $.ajax({
      url: 'check-user',
      type: 'POST',
      data: { userid: userid },
      success: function(response){
        if(response.status === 'valid') {
          $('#userNameResult').css('color','green').html('Name: ' + response.name);
        } else {
          $('#userNameResult').css('color','red').html('Invalid User ID');
        }
      },
      error: function(){
        $('#userNameResult').css('color','red').html('Error checking user.');
      }
    });
  });
});
</script>


<section class="product-container">
  <div class="container">
    <!-- Left: Products -->
    <div class="product-left">
      <input type="text" id="productSearch" placeholder="Search products..." class="search-bar">

      <div class="product-section">
        <?php
          $query = "SELECT * FROM imaksoft_product";
          $result = mysqli_query($conn, $query);
          while ($row = mysqli_fetch_assoc($result)) {
        ?>
          <div class="product-card" 
               data-id="<?= $row['id'] ?>" 
               data-title="<?= $row['title'] ?>" 
               data-price="<?= $row['aprice'] ?>" 
               data-image="../admin/<?= $row['image'] ?>">
            <img src="../admin/<?= $row['image'] ?>" alt="<?= $row['title'] ?>" class="product-img">
            <h3 class="product-title"><?= $row['title'] ?></h3>
            <p class="product-desc"><?= $row['cat'] ?></p>
            <div class="price">
              <span class="discount-price">₹<?= $row['aprice'] ?></span>
              <span class="actual-price">₹<?= $row['price'] ?></span>
            </div>
            <button class="add-cart-btn">Add to Cart</button>
          </div>
        <?php } ?>
      </div>
    </div>

    <!-- Right: Cart Sidebar -->
    <div class="cart-right">
      <h3>Cart Items</h3>
      <ul id="cartList">
        <li>No products added.</li>
      </ul>

      <div id="cartTotals" style="margin-top:10px; font-weight:bold;">
        Total Items: 0 | Total Price: ₹0
      </div>

      <!-- Checkout Section -->
      <div id="checkout" style="margin-top:15px;">
        <form id="checkoutForm" action="product-process" method="post">
          <label>User ID:</label>
          <label>User ID:</label>
<input type="text" name="userid" id="userId" placeholder="Enter User ID" 
       style="width:100%; padding:5px; margin-bottom:5px;" required>

<div id="userNameResult" style="color:blue; margin-bottom:8px;"></div>


          <div>Wallet Balance: ₹<span id="walletBalance">0</span></div>

          <label style="margin-top:10px;">Payment Method:</label><br>
          <input type="radio" name="payment" value="wallet" id="payWallet"> Wallet<br>
          <input type="radio" name="payment" value="cash" id="payCash" checked> Cash<br>

          <input type="hidden" name="total_price" id="totalPriceInput" value="0">

          <button type="submit" id="submitOrder" 
                  style="margin-top:10px; padding:6px 12px; background:#198800; color:#fff; border:none; border-radius:5px;">
            Submit Order
          </button>
        </form>
      </div>
    </div>
  </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {

  // === Realtime Search ===
  document.getElementById('productSearch').addEventListener('keyup', function() {
    let value = this.value.toLowerCase();
    document.querySelectorAll('.product-card').forEach(card => {
      let text = card.innerText.toLowerCase();
      card.style.display = text.includes(value) ? 'block' : 'none';
    });
  });

  // === Cart System ===
  let cart = [];
  updateCartList();

  document.querySelectorAll('.add-cart-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      let card = this.closest('.product-card');
      let product = {
        id: card.dataset.id,
        title: card.dataset.title,
        price: parseFloat(card.dataset.price),
        qty: 1
      };

      let existing = cart.find(item => item.id === product.id);
      if (!existing) {
        cart.push(product);
        updateCartList();
        this.innerText = "Added ✓";
        this.style.background = "#999";
      } else {
        alert("Already in cart!");
      }
    });
  });

  function updateCartList() {
    let list = document.getElementById('cartList');
    list.innerHTML = '';
    if (cart.length === 0) {
      list.innerHTML = '<li>No products added.</li>';
    } else {
      cart.forEach((item, index) => {
        let li = document.createElement('li');
        li.innerHTML = `
          ${item.title} - ₹${item.price}
          <input type="number" min="1" value="${item.qty}" data-index="${index}" class="qtyInput">
        `;
        list.appendChild(li);
      });

      document.querySelectorAll('.qtyInput').forEach(input => {
        input.addEventListener('change', function() {
          let idx = this.dataset.index;
          cart[idx].qty = parseInt(this.value);
          updateCartTotals();
        });
      });
    }
    updateCartTotals();
  }

  function updateCartTotals() {
    let totalQty = 0, totalPrice = 0;
    cart.forEach(item => {
      totalQty += item.qty;
      totalPrice += item.qty * item.price;
    });
    document.getElementById('cartTotals').innerText = 
      `Total Items: ${totalQty} | Total Price: ₹${totalPrice}`;
    document.getElementById('totalPriceInput').value = totalPrice;
    recheckWallet(totalPrice);
  }

  // === Wallet Handling ===
  document.getElementById('walletBalance').innerText = '0';
  document.getElementById('payWallet').disabled = true;

  document.getElementById('userId').addEventListener('keyup', function() {
    let userid = this.value.trim();
    if (userid.length > 0) {
      fetch(`get_wallet?userid=${userid}`)
        .then(res => res.text())
        .then(balance => {
          balance = parseFloat(balance);
          if (isNaN(balance)) balance = 0;
          document.getElementById('walletBalance').innerText = balance.toFixed(2);
          recheckWallet(getCartTotalPrice());
        });
    } else {
      document.getElementById('walletBalance').innerText = '0';
      document.getElementById('payWallet').disabled = true;
      document.getElementById('payCash').checked = true;
    }
  });

  function getCartTotalPrice() {
    return cart.reduce((sum, item) => sum + item.price * item.qty, 0);
  }

  function recheckWallet(totalPrice) {
    let balance = parseFloat(document.getElementById('walletBalance').innerText);
    if (balance >= totalPrice && totalPrice > 0) {
      document.getElementById('payWallet').disabled = false;
      document.getElementById('payWallet').checked = true;
      document.getElementById('payCash').checked = false;
    } else {
      document.getElementById('payWallet').disabled = true;
      document.getElementById('payCash').checked = true;
    }
  }

});
</script>



<style>
/* ---- Layout ---- */
.container {
  display: flex;
  gap: 20px;
}

/* Left products */
.product-left {
  flex: 1;
}

/* Right cart sidebar */
.cart-right {
  width: 300px;
  background: #f7f7f7;
  padding: 15px;
  border-radius: 10px;
  max-height: 80vh;
  overflow-y: auto;
}

.cart-right h3 {
  margin-bottom: 15px;
  text-align: center;
}

.cart-right ul {
  list-style: none;
  padding: 0;
}

.cart-right li {
  padding: 8px 5px;
  border-bottom: 1px solid #ccc;
  font-size: 13px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.cart-right input {
  width: 40px;
  text-align: center;
  font-size: 13px;
}

/* ---- Search Bar ---- */
.search-bar {
  width: 100%;
  display: block;
  padding: 10px 15px;
  font-size: 14px;
  border-radius: 8px;
  border: 1px solid #ccc;
  margin-bottom: 20px;
  outline: none;
  transition: 0.3s;
}
.search-bar:focus {
  border-color: #198800;
  box-shadow: 0 0 5px rgba(25,136,0,0.3);
}

/* ---- Product Grid ---- */
.product-section {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 15px;
}

.product-card {
  background: #fff;
  border-radius: 10px;
  padding: 12px;
  text-align: center;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
  transition: 0.2s;
}
.product-card:hover {
  transform: translateY(-4px);
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.product-img {
  width: 100%;
  height: 180px;
  border-radius: 8px;
  object-fit: cover;
}

.product-title {
  font-size: 13px;
  font-weight: 700;
  margin: 8px 0 4px;
}

.product-desc {
  font-size: 12px;
  color: #666;
  margin-bottom: 8px;
  display: -webkit-box;
  -webkit-line-clamp: 1;
  -webkit-box-orient: vertical;
  overflow: hidden;
  text-overflow: ellipsis;
}

.price {
  font-size: 13px;
}

.discount-price {
  color: #198800;
  font-weight: bold;
  margin-right: 5px;
}

.actual-price {
  text-decoration: line-through;
  color: #999;
}

.add-cart-btn {
  background: #198800;
  color: #fff;
  border: none;
  padding: 6px 12px;
  border-radius: 5px;
  font-size: 12px;
  cursor: pointer;
  transition: 0.2s;
}
.add-cart-btn:hover {
  background: #116000;
}

/* ---- Responsive ---- */
@media (max-width: 1024px) {
  .container { flex-direction: column; }
  .cart-right { width: 100%; margin-top: 20px; }
  .product-section { grid-template-columns: repeat(2, 1fr); }
}
@media (max-width: 480px) {
  .product-section { grid-template-columns: 1fr; }
}
</style>
</div>
</div>

</div>
</div>
</div>

<?php }else if($_REQUEST['inc']=='approved'){?>

<div class="main-panel">
<div class="content">
<div class="page-inner">

<div class="row">
<div class="col-md-12">

<div class="card">
<div class="card-header">
<div class="card-title">View Deposit</div>
</div>
<div class="card-body" style="overflow:auto;">

<table class="table table-hover table-bordered mb-0 text-md-nowrap text-lg-nowrap text-xl-nowrap table-striped ">
<thead>
<tr align="center">
<th style="text-align:center;">Sl_No</th>
<th style="text-align:center;">User_ID</th>
<th style="text-align:center;">Name</th>
<th style="text-align:center;">Amount</th>
<th style="text-align:center;">Date/Time</th>
<th style="text-align:center;">Action</th>
</tr>
</thead>
<tbody>
<?php
$tname = 'mi_deposit';
$lim = 100;
$tpage = 'deposit.php';

$where = "ORDER BY `id` DESC";

$sql = "SELECT * FROM `$tname` $where LIMIT $lim";
$result = mysqli_query($conn, $sql);
$num = mysqli_num_rows($result);
$i = 1;
?>

<tbody>
<?php if ($num > 0): ?>
    <?php while ($fetch = mysqli_fetch_assoc($result)): ?>
        <tr>
            <td align="center"><?=$i?></td>
            <td align="center"><?=$fetch['userid']?></td>
            <td align="center"><?=getFromUserID($conn, $fetch['userid'], 'name')?></td>
            <td align="center"><?=$fetch['amount']?></td>
            <td align="center"><?=$fetch['date']?></td>
            <td align="center">
                <a href="deposit-process?case=delete&id=<?=$fetch['id']?>" 
                   onclick="return confirm('Are you want to sure to delete this?')">
                   <img src="assets/img/delete.png" height="22" />
                </a>
            </td>
        </tr>
        <?php $i++; ?>
    <?php endwhile; ?>
<?php else: ?>
    <tr>
        <td colspan="7" align="center" style="color:#FF0000;">No Record Found!</td>
    </tr>
<?php endif; ?>
</tbody>

</table>
<div align="center"><?=$pagination?></div>

</div>
</div>
</div>
</div>

</div>
</div>
</div>

<?php }?>

</div>
</div>
<script type="text/javascript">
//<![CDATA[

theForm.oldSubmit = theForm.submit;
theForm.submit = WebForm_SaveScrollPositionSubmit;

theForm.oldOnSubmit = theForm.onsubmit;
theForm.onsubmit = WebForm_SaveScrollPositionOnSubmit;
//]]>
</script>
</form>
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/jquery-ui/ui/widgets/datepicker.js"></script>
<script src="assets/plugins/bootstrap/popper.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/ionicons/ionicons.js"></script>
<script src="assets/plugins/chart.js/Chart.bundle.min.js"></script>
<script src="assets/plugins/jquery-sparkline/jquery.sparkline.min.js"></script>
<script src="assets/js/chart.flot.sampledata.js"></script>
<script src="assets/js/eva-icons.min.js"></script>
<script src="assets/plugins/moment/moment.js"></script>
<script src="assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="assets/plugins/perfect-scrollbar/p-scroll.js"></script>
<script src="assets/plugins/side-menu/sidemenu.js"></script>
<script src="assets/js/sticky.js"></script>
<script src="assets/plugins/sidebar/sidebar.js"></script>
<script src="assets/plugins/sidebar/sidebar-custom.js"></script>
<script src="assets/plugins/raphael/raphael.min.js"></script>
<script src="assets/plugins/morris.js/morris.min.js"></script>
<script src="assets/js/script.js"></script>
<script src="assets/js/index.js"></script>
<script src="assets/js/themecolor.js"></script>
<script src="assets/js/swither-styles.js"></script>
<script src="assets/js/custom.js"></script>
<script src="assets/switcher/js/switcher.js"></script>
<script>
        $(document).ready(function () {
            $("#copy").text($("#ref_link").val());
            $('.clipboard').on('click', function () {
                var $temp = $("<input>");
                var $url = $("#ref_link").val();//$(location).attr('href');
                //$("#linkModal").modal();
                $("body").append($temp);
                $temp.val($url).select();
                document.execCommand("copy");
                //$("#lblCopyLink").text($temp[0].value);
                alert("link copied");
                $temp.remove();
            });
        });
    </script>
</body>
</html>
